/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.relocations.org.h2.security.auth;

import net.impactdev.impactor.relocations.org.h2.engine.ConnectionInfo;
import net.impactdev.impactor.relocations.org.h2.util.StringUtils;

public class AuthenticationInfo {
    private ConnectionInfo connectionInfo;
    private String password;
    private String realm;
    Object nestedIdentity;

    public AuthenticationInfo(ConnectionInfo connectionInfo) {
        this.connectionInfo = connectionInfo;
        this.realm = connectionInfo.getProperty("AUTHREALM", null);
        if (this.realm != null) {
            this.realm = StringUtils.toUpperEnglish(this.realm);
        }
        this.password = connectionInfo.getProperty("AUTHZPWD", null);
    }

    public String getUserName() {
        return this.connectionInfo.getUserName();
    }

    public String getRealm() {
        return this.realm;
    }

    public String getPassword() {
        return this.password;
    }

    public ConnectionInfo getConnectionInfo() {
        return this.connectionInfo;
    }

    public String getFullyQualifiedName() {
        if (this.realm == null) {
            return this.connectionInfo.getUserName();
        }
        return this.connectionInfo.getUserName() + "@" + this.realm;
    }

    public Object getNestedIdentity() {
        return this.nestedIdentity;
    }

    public void setNestedIdentity(Object object) {
        this.nestedIdentity = object;
    }

    public void clean() {
        this.password = null;
        this.nestedIdentity = null;
        this.connectionInfo.cleanAuthenticationInfo();
    }
}

